package Model.Classes;

import Model.Exceptions.ValidationException;

/**
 * Represents an Item. Every Item have one User.
 * 
 * @author Tamir Schwartzberg (tamir5021@gmail.com).
 */
public class Item {

	/**
	 * Represents the Items id.
	 */
	private int id;

	/**
	 * Represents the Items mission description.
	 */
	private String mission;

	/**
	 * Represents the Items mission location.
	 */
	private String location;

	/**
	 * Represents the Items Date of occurring.
	 */
	private String futureDate;

	/**
	 * Represents the Items User.
	 */
	private User user;

	public Item() {
		super();
	}

	/**
	 * Creates an Items with a specified mission, location, user and date of
	 * occurring. set the currentDate to date of adding.
	 * 
	 * @param mission
	 *            The Items mission description.
	 * @param location
	 *            The Items mission location.
	 * @param futureDate
	 *            The Items date of occurring.
	 * @param user
	 *            The Items user which it belongs to.
	 * @throws ValidationException
	 */
	public Item(String mission, String location, String futureDate, User user) throws ValidationException {
		setMission(mission);
		setLocation(location);
		setFutureDate(futureDate);
		setUser(user);
	}

	/**
	 * Gets the Items Id.
	 * 
	 * @return An integer number representing the Items id.
	 */
	public int getId() {
		return id;
	}

	/**
	 * Sets the Items id.
	 * 
	 * @param id
	 *            An integer number containing the Items id.
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Gets the Items mission.
	 * 
	 * @return A string representing the Items mission description.
	 */
	public String getMission() {
		return mission;
	}

	/**
	 * Sets the Items mission.
	 * 
	 * @param mission
	 *            A string containing the Items mission description.
	 * @throws ValidationException
	 */
	public void setMission(String mission) throws ValidationException {
		Validator.checkField(mission, "Mission");
		this.mission = mission;
	}

	/**
	 * Gets the Items location.
	 * 
	 * @return A string representing the Items mission location.
	 */
	public String getLocation() {
		return location;
	}

	/**
	 * Sets the Items location.
	 * 
	 * @param location
	 *            A string containing the Items mission location.
	 * @throws ValidationException
	 */
	public void setLocation(String location) throws ValidationException {
		Validator.checkField(location, "Location");
		this.location = location;
	}

	/**
	 * Gets the Items Date of occurring.
	 * 
	 * @return A String representing the Items mission date of occurring.
	 */
	public String getFutureDate() {
		return futureDate;
	}

	/**
	 * Sets the Items Date of occurring.
	 * 
	 * @param futureDate
	 *            A String containing the Items mission date of occurring
	 * @throws ValidationException
	 */
	public void setFutureDate(String futureDate) throws ValidationException {
		Validator.checkDate(futureDate);
		this.futureDate = futureDate;
	}

	/**
	 * Gets the Items User.
	 * 
	 * @return A User object representing the Items user which it belongs to.
	 */
	public User getUser() {
		return user;
	}

	/**
	 * Sets the Items User.
	 * 
	 * @param user
	 *            A User object containing the Items user which it belongs to.
	 */
	public void setUser(User user) {
		this.user = user;
	}

	@Override
	public String toString() {
		return "[" + id + ", " + mission + ", " + location + ", " + futureDate + ", " + user.getId() + "]";
	}

	@Override
	public boolean equals(Object other) {
		if (other == null)
			return false;
		if (other == this)
			return true;
		if (!(other instanceof Item))
			return false;
		Item otherItem = (Item) other;

		if ((id != otherItem.getId()) || (!mission.equals(otherItem.getMission()))
				|| (!location.equals(otherItem.getLocation())) || (!futureDate.equals(otherItem.getFutureDate()))
				|| (user.getId() != otherItem.user.getId()))
			return false;
		return true;
	}
}